# -*- coding: iso-8859-1 -*-

#
# This file is a part of the Bayes Blocks library
#
# Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
# Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License (included in file License.txt in the
# program package) for more details.
#
# $Id: PlotHelpers.py 5 2006-10-26 09:44:54Z ah $
#

import Helpers
import Numeric
try:
    import biggles
    foundbiggles = 1
except ImportError:
    foundbiggles = 0

# default transoformation from matlab to project plots from 3d to 2d
view=Numeric.array([
    [7.9335334e-01,  -6.0876143e-01,  -1.0621134e-17,  -9.2295956e-02],
    [3.0438071e-01,   3.9667667e-01,   8.6602540e-01,  -7.8354139e-01],
    [5.2720286e-01,   6.8706415e-01,  -5.0000000e-01,   8.3031205e+00],
    [0.0000000e+00,   0.0000000e+00,   0.0000000e+00,   1.0000000e+00]])

def PlotNodes(x, y, color="black"):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    s = Numeric.array(Helpers.GetMeanV(x))
    t = Numeric.array(Helpers.GetMeanV(y))
    return biggles.Curve(s, t, color=color )

def PlotNodes3(x, y, z, color="black", view=view):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    tmp = [Helpers.GetMeanV(x), Helpers.GetMeanV(y),Helpers.GetMeanV(z)];
    tmp.append([1] * len(tmp[0]))
    t = Numeric.array(tmp)
    p = Numeric.matrixmultiply(view[0:2,:],t)
    return biggles.Curve(p[0], p[1], color=color)

def PlotFunction(func, plotrange, plotpoints=100, color="black"):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    s = Numeric.arrayrange(plotrange[0],
                           plotrange[1],
                           float(plotrange[1]-plotrange[0])/plotpoints)
    t = map(func, s)
    return biggles.Curve(s, t, color=color)

def ParametricPlot(func, plotrange, plotpoints=100, color="black"):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    s = Numeric.arrayrange(float(plotrange[0]),
                           float(plotrange[1]),
                           float(plotrange[1]-plotrange[0])/plotpoints)
    t = Numeric.array([map(func[0], s), map(func[1], s)])
    return biggles.Curve(t[0], t[1], color=color)

def ParametricPlot3(func, plotrange, plotpoints=100, color="black",
                    view=view):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    s = Numeric.arrayrange(float(plotrange[0]),
                           float(plotrange[1]),
                           float(plotrange[1]-plotrange[0])/plotpoints)
    t = Numeric.array([map(func[0], s), map(func[1], s),
                       map(func[2], s), [1] * s.shape[0]])
    p = Numeric.matrixmultiply(view[0:2,:],t)
    return biggles.Curve(p[0], p[1], color=color)

def Scatter(data):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    return biggles.Points(data[0],data[1],type="dot")

def Scatter3(data, view=view):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    t = Numeric.array([data[0], data[1], data[2], [1] * len(data[0])])
    p = Numeric.matrixmultiply(view[0:2,:],t)
    return biggles.Points(p[0], p[1], type="dot")

def PlotSteplenCosts(mynet, npoints=100, color="black"):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    maxval = mynet.SearchStepLens()
    s = Numeric.arrayrange(0, maxval, maxval/npoints);
    t = []
    for k in s:
        mynet.RepeatAllSteps(k)
        t.append(mynet.Cost())
    return biggles.Curve(s, t, color=color)

def Surf(data, view=view, color="black"):
    if not foundbiggles:
        raise EnvironmentError("Biggles not found, cannot Plot!")
    d = Numeric.resize(data, (4, data.shape[1]*data.shape[2]))
    d[3,:] = 1
    t = Numeric.matrixmultiply(view[0:2,:], d)
    p = Numeric.reshape(t, (2, data.shape[1], data.shape[2]))
    plot = []
    for i in range(p.shape[1]):
        plot.append(biggles.Curve(p[0,i,:], p[1,i,:], color=color))
    for j in range(p.shape[1]):
        plot.append(biggles.Curve(p[0,:,j], p[1,:,j], color=color))
    return plot
