# -*- coding: iso-8859-1 -*-
 
from distutils.core import setup, Extension
from distutils.cmd import Command
from distutils.command.build import build
import string, os, sys

INCLUDE_DIRS = []

try:
    import numpy
except:
    try:
	import Numeric
    except:
	HAVENUMERIC = 0
	print "Not using Numeric"
    else:
	HAVENUMERIC = 1
	print "Using Numeric"
else:
    HAVENUMERIC = 2
    print "Using NumPy"
    import numpy.distutils.misc_util
    INCLUDE_DIRS += numpy.distutils.misc_util.get_numpy_include_dirs()

if HAVENUMERIC == 2:
    MATCONFIG="""\
/* Automatically generated by setup.py, do not edit! */
#define WITH_PYTHON 1
#define WITH_NUMPY 1
/* #undef WITH_NUMERIC */
#define WITH_MATLAB 1
"""
    NOMATCONFIG="""\
/* Automatically generated by setup.py, do not edit! */
#define WITH_PYTHON 1
#define WITH_NUMPY 1
/* #undef WITH_NUMERIC */
/* #undef WITH_MATLAB */
"""
elif HAVENUMERIC == 1:
    MATCONFIG="""\
/* Automatically generated by setup.py, do not edit! */
#define WITH_PYTHON 1
/* #undef WITH_NUMPY */
#define WITH_NUMERIC 1
#define WITH_MATLAB 1
"""
    NOMATCONFIG="""\
/* Automatically generated by setup.py, do not edit! */
#define WITH_PYTHON 1
/* #undef WITH_NUMPY */
#define WITH_NUMERIC 1
/* #undef WITH_MATLAB */
"""
else:
    MATCONFIG="""\
/* Automatically generated by setup.py, do not edit! */
#define WITH_PYTHON 1
/* #undef WITH_NUMPY */
/* #undef WITH_NUMERIC */
#define WITH_MATLAB 1
"""
    NOMATCONFIG="""\
/* Automatically generated by setup.py, do not edit! */
#define WITH_PYTHON 1
/* #undef WITH_NUMPY */
/* #undef WITH_NUMERIC */
/* #undef WITH_MATLAB */
"""
    

class mybuild(build):
    sub_commands = [('check_matlab', None)] + build.sub_commands

class check_matlab(Command):

    description = "Check for Matlab location"

    user_options = [
        ('matlab=', None,
         "Matlab binary location"),
        ]

    def check_matlab(self, dist):
        pass

    def initialize_options(self):
        self.matlab = None

    def finalize_options(self):
        pass

    def run(self):
        root=""
        arch=""
        if sys.platform != 'win32':
            f = os.popen("%s -n" % self.matlab, "r")
            for line in f:
                if string.find(line, "  r   MATLAB ") >= 0:
                    root=line[30:].strip()
                    print "Using Matlab at root", root
                if string.find(line, "  r   ARCH ") >= 0:
                    arch=line[30:].strip()
                    print "Building for Matlab architecture", arch
            if arch != "":
                self.distribution.command_options['build_ext'] = {
                    'include_dirs': ('check_matlab', [root+"/extern/include"]),
                    'library_dirs': ('check_matlab', [root+"/bin/"+arch, root+"/sys/os/"+arch]),
                    'rpath': ('check_matlab', [root+"/bin/"+arch, root+"/sys/os/"+arch]),
                    'libraries': ('check_matlab', ["mat", "mx"])}
                f=open('src/config.h', 'w')
                f.write(MATCONFIG)
                f.close()
            else:
                f=open('src/config.h', 'w')
                f.write(NOMATCONFIG)
                f.close()
        else:
            f=open('src/config.h', 'w')
            f.write(NOMATCONFIG)
            f.write("#define BAD_MATHLIB 1")
            f.close()

SOURCES=["src/Net.cc", "src/Node.cc", "src/MatlabSaver.cc",
         "src/XMLSaver.cc", "src/PythonSaver.cc",
         "src/NodeLoader.cc", "src/MatlabLoader.cc",
         "src/PythonLoader.cc", "src/Decay.cc", "src/DecayCounter.cc",
         "src/NodeFactory.cc", "src/SpecFun.cc", "src/Net_wrap.cc"]

long_description = """\
Python module for Bayes Blocks library.
"""

if sys.platform == 'win32':
    ext = Extension("bblocks._Net",
                    sources=SOURCES,
		    include_dirs=INCLUDE_DIRS + ["src"],
                    language='c++', extra_compile_args=["/GR"])
else:
    ext = Extension("bblocks._Net",
                    sources=SOURCES,
		    include_dirs=INCLUDE_DIRS + ["src"],
                    language='c++')

setup(
    cmdclass        = {'check_matlab': check_matlab,
                       'build': mybuild},
    name            = "bblocks",
    version         = "1.1.1",
    author          = "Harri Valpola, Antti Honkela, Markus Harva, Alexander Ilin, Tapani Raiko and Tomas stman",
    author_email    = "bayeslib@cis.hut.fi",
    license         = "GPL",
    description     = "Bayes Blocks library",
    url             = "http://www.cis.hut.fi/projects/bayes/software/",
    long_description= long_description,
    packages        = ["bblocks"],
    ext_modules     = [ext])

if os.access('src/config.h', os.F_OK):
    os.remove('src/config.h')
