function x = acfeedfw(s0, tnet, approximation)
% ACFEEDFW  Do feedforward with acprobdist_alpha sources
%
%    Usage:
%      x = acfeedfw(s, tnet, approximation)
%      where sources should be acprobdist_alpha and x
%      will be a cell array with intermediate results
%      from several phases of computation.

% Copyright (C) 1999-2005 Antti Honkela, Harri Valpola,
% Xavier Giannakopoulos and Matti Tornio
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if (~isa(s0, 'acprobdist_alpha'))
  error('Use acfeedfw only with sources of type acprobdist_alpha')
end

if nargin < 3,
  approximation = 'hermite';
end

s = s0(:,1:end-1);
x = cell(1, 5);

sdim = size(s, 1);
tdim = size(s, 2);
hdim = size(tnet.w1, 1);
odim = size(tnet.w2, 1);

if (sdim ~= odim)
  error('Network input and output dimensions need to be equal')
end

% Initialisation:         x{1} = s
x{1}.e = s.e;
x{1}.var = s.var;
x{1}.multi = repmat(eye(sdim), [1 1 tdim]);

% First linear layer:     x{2} = A*x{1} + a
x{2}.e = tnet.w1.e * x{1}.e + repmat(tnet.b1.e, [1, tdim]);
x{2}.extra = tnet.w1.var * (x{1}.e.^2 + x{1}.var) + ...
    repmat(tnet.b1.var, [1, tdim]);
x{2}.multi = reshape(tnet.w1.e * reshape(x{1}.multi, [sdim sdim*tdim]), ...
		     [hdim sdim tdim]);
x{2}.var = x{2}.extra + tnet.w1.e.^2 * x{1}.var;

% Nonlinear hidden layer: x{3} = phi(x{2})
if strcmp(approximation, 'hermite'),
  [x{3}, x{6}] = nonlin_hermite(x{2}, tnet.nonlin);
elseif strcmp(approximation, 'taylor'),
  x{3} = nonlin_taylor(x{2}, tnet.nonlin);
elseif strcmp(approximation, 'adaptive'),
  x{3} = nonlin_adaptive(x{2}, tnet.nonlin);
else
  error('Unsupported approximation')
end

% Second linear layer:    x{4} = B*x{3} + b
x{4}.e = tnet.w2.e * x{3}.e + repmat(tnet.b2.e, [1, tdim]) + x{1}.e;
x{4}.extra = tnet.w2.var * x{3}.e.^2 + ...
    tnet.w2.e.^2 * x{3}.extra + tnet.w2.var * x{3}.var + ...
    repmat(tnet.b2.var, [1, tdim]);
x{4}.multi = reshape(tnet.w2.e * reshape(x{3}.multi, [hdim sdim*tdim]), ...
		     [odim sdim tdim]) + x{1}.multi;
x{4}.var = x{4}.extra + ...
    reshape(sum(repmat(shiftdim(x{1}.var, -1), [odim 1 1]) ...
		.* (x{4}.multi .^ 2), 2), [odim tdim]) + x{1}.var;

% Take AC into account for multivar
mv = x{4}.multi;
x{5} = mv;
for i=1:size(mv,1)
  mv(i,i,:)=mv(i,i,:)-reshape(s0.ac(i,2:end), [1 1 size(mv,3)]);
end
x{4}.multi = mv;

% Update the variance
[d1 d2 d3] = size(x{4}.multi);
mv = reshape(sum(repmat(reshape(s0.var(:,1:end-1), [1 d2 d3]), ...
			[d1 1 1]) .* x{4}.multi .^ 2, 2), [d1 d3]);
x{4}.var = mv + x{4}.extra;
