function [x2, t2, c2] = backtracking_search(x0, step, t0, f, args, c0)
% BACKTRACKING_SEARCH  Backtracking linesearch with quadratic interpolation

% Copyright (C) 1996-2006 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos, and Matti Tornio
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.


epsilon = 1e-6;
epsilon2 = 1e-10;
maxiters = 30;

t1 = 0;
if nargin > 5,
  c1 = c0;
  x1 = x0;
else
  [x1, c1] = feval(f, x0, step, t1, args);
  c0 = c1;
end

t2 = 10 * t0;
c2 = inf;
c3 = inf;

itercount = 0;

% Variation of backtracking linesearch (with quadratic interpolation)
while c2 > (c1 + epsilon),
  itercount = itercount + 1;
  if (t2 < epsilon2) | (itercount > maxiters),
    warning('Linesearch failed to converge');
    x2 = x0;
    c2 = c0;
    t2 = t0;
    return;
  end
 
  % If three points are available, use quadratic interpolation
  if isfinite(c3),
    tnew = (t1.^2 .* (c2-c3) + t2.^2 .* (c3-c1) + t3.^2 .* (c1-c2)) ./ ...
	   (2*(t1 .* (c2-c3) + t2 .* (c3-c1) + t3 .* (c1-c2)));
    tnew = max([min([tnew .5 * t2]) .1 * t2]);
  else
    tnew = .1 * t2;
  end

  c3 = c2;
  t3 = t2;
  t2 = tnew;
  [x2, c2] = feval(f, x0, step, t2, args);

  if args.status.debug,
    fprintf('Variance update:             c=%.16g, alpha=%f\n', c2, t2);
  end
end
