function [x2, t2, c2] = bisection_search(x0, step, t0, f, args, c0)
% BISECTION_SEARCH  Cut step lengths by half until cost does not increase

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

epsilon = 1e-6;
epsilon2 = 1e-8;
maxiters = 30;

t1 = 0;
if nargin > 5,
  c1 = c0;
  x1 = x0;
else
  [x1, c1] = feval(f, x0, step, t1, args);
  c0 = c1;
end
t2 = t0;
c2 = Inf;

while (c2 > (c1 + epsilon))
  t2 = .5*t2;
  [x2, c2] = feval(f, x0, step, t2, args);
end
