function tmin = cubic_minimum(t, c),
% CUBIC_MINIMUM Find the minimum with cubic interpolation

% Warnings are disabled, since polyfit tends to give warnings when the 
% polynomial is ill-behaved
warning('off', 'all');

p = polyfit(t, c, 3);

a = p(1);
b = p(2);
c = p(3);
r1 = (-b+sqrt(b^2-3*a*c)) / (3*a);
r2 = (-b-sqrt(b^2-3*a*c)) / (3*a);

% Find the extremum where the second derivative is positive
if (6*a*r1+2*b) > 0,
  tmin = r1;
else
  tmin = r2;
end

warning('on', 'all');
