function [data_em, s, ntd_em, s2] = embed(data, delays, dim, timeindep),
% EMBED  Embed data vector with delayed samples
%
%  [data_em, s] = EMBED(data, delays, dim, timeindep)
%
%  Embeds the given data vector with delayed samples. Suitable values for
%  initial sources are extracted using PCA. Delays can be omitted or an empty
%  vector can be used to use the default delays. Timeindep can be given to
%  partition the data.
%

% Copyright (C) 2002-2005 Harri Valpola, Antti Honkela and Matti Tornio.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

% Use default delays of 0, 1, 2, 4, 8 and 16 samples
if nargin < 2,
  delays = [0 2.^(0:4)];
  dim = size(data);
else 
  if isempty(delays),
    delays = [0 2.^(0:4)];
  end
end

[Nx T] = size(data);
n = size(delays, 2);
padding = abs(max(delays)) + abs(min(delays));

if nargin < 4,
  parts = 1;
else
  timeindep = [0 timeindep T];
  parts = size(timeindep, 2);
end

% Generate delayed samples
data_em = nan * ones(Nx * n, T + padding * parts);

if parts == 1,
  for i = 1:n,
    data_em(((i - 1) * Nx + 1):(i * Nx), ...
	    (delays(i) + 1):(delays(i) + T)) = data;
  end
  s = real(nanpca(data_em, dim));
else
  s = [];
  data_em = [];
  ntd_em = [];
  for j = 2:parts,
    ntd_em = [ntd_em timeindep(j) + padding * (j - 1)];
    data_new = nan * ones(Nx * n, timeindep(j) - timeindep(j - 1) + padding);
    for i = 1:n,
      curpart = [timeindep(j-1)+1:timeindep(j)];
      data_new(((i - 1) * Nx + 1):(i * Nx), ...
	    (delays(i) + (1:size(curpart, 2)))) = data(:,curpart);
    end
    data_em = [data_em data_new];
    % Extract sources using PCA
    s_new = real(nanpca(data_new, dim));
    s = [s s_new];
  end
  ntd_em = ntd_em(1:end-1);
  s2 = real(nanpca(data_em, dim));
end
