function [dm, dv, dmv, dev] = ...
    feedback_adaptive(dgm0, dgv0, dgmv, dgev, m_in, v_in, mv_in, ev_in, ...
                     m_out, v_out, nonlin, aux, lvar, hvar, status)
% FEEDBACK_ADAPTIVE  

[dm1, dv1, dmv1, dev1] = ...
    feedback_taylor(dgm0(lvar), dgv0(lvar), dgmv(lvar), dgev(lvar), ...
		    m_in(lvar), v_in(lvar), mv_in(lvar), ev_in(lvar), ...
		    nonlin);
[dm2, dv2, dmv2, dev2] = ...
    feedback_hermite(dgm0(hvar), dgv0(hvar), dgmv(hvar), dgev(hvar), ...
		     m_in(hvar), v_in(hvar), mv_in(hvar), ev_in(hvar), ...
		     m_out(hvar), v_out(hvar), nonlin, aux, status);

dm(lvar)  = dm1;
dv(lvar)  = dv1;
dmv(lvar) = dmv1;
dev(lvar) = dev1;

dm(hvar)  = dm2;
dv(hvar)  = dv2;
dmv(hvar) = dmv2;
dev(hvar) = dev2;
