function [dm, dv, dmv, dev] = ...
    feedback_taylor(dgm0, dgv0, dgmv, dgev, m_in, v_in, mv_in, ev_in, nonlin)
% FEEDBACK_TAYLOR  Evaluate the gradients of Taylor
%   approximation of nonlinearity

[der1, der2, der3] = feval(['d3' nonlin], m_in);

temp = .5 * der2 .* dgm0;

dv = temp .* (temp > 0) + (der1 .^ 2) .* dgv0;

dm = dgm0 .* (der1 + .5*v_in .* der3 .* (temp > 0)) + ...
     2 * dgv0 .* v_in .* der2 .* der1 + ...
     2 * dgev .* ev_in .* der2 .* der1 + ...
     reshape(sum(dgmv .* mv_in, 2), size(der2)) .* der2;
dev = (der1 .^ 2) .* dgev;

dmv = repmat(reshape(der1, [size(m_in, 1) 1 size(dgmv, 3)]),...
             [1 size(dgmv, 2) 1]) .* dgmv;
