function [c, c2] = kl_acparam(param, meanprior, varprior, dim, notimedep)

% Copyright (C) 2002-2005 Harri Valpola, Antti Honkela and Matti Tornio
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if nargin < 4
  dim = 2;
end

effvar = normalvar(varprior);

% Set values which ignore time dependence to perfect match
if nargin >= 5 & ~isempty(notimedep),
  notimedep = [zeros(size(meanprior.e, 1), 1) notimedep];
  meanprior.e = meanprior.e .* ~notimedep + param.e .* notimedep;
  meanprior.var = meanprior.var .* ~notimedep;
end

c = ...
    -.5 * prod(size(param)) - .5 * sum(sum(log(2*pi*param.nvar))) + ...
    .5 * log(2*pi) * prod(size(param)) + ...
    sum(varprior.e) * prod(size(param)) / prod(size(varprior)) + ...
    .5 * sum(sum((param.e - meanprior.e).^2 + ...
		  param.nvar + meanprior.var, dim) ./ effvar);

if nargout > 1,
  c2 = ...
      -.5 ...
      -.5 * log(2*pi*param.nvar) ...
      +.5 * log(2*pi) ...
      + repmat(varprior.e, 1, size(param, 2)) ...
      +.5 * ((param.e - meanprior.e).^2 + ...
	     param.nvar + meanprior.var) ./ repmat(effvar, 1, ...
						   size(param, 2));
end
