function [c, c2] = kl_data(data, meanprior, varprior, dim, missing)

% Copyright (C) 2002-2005 Harri Valpola, Antti Honkela and Matti Tornio.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if nargin < 4
  dim = 2;
end

effvar = normalvar(varprior);
sizedata = prod(size(data));
misfit = data - meanprior;

% Ignore missing values
if nargin >= 5 & ~isempty(missing),
  sizedata = sizedata - sum(sum(missing));
  misfit(find(missing)) = probdist(0, 0);
end

c = ...
    .5 * log(2*pi) * sizedata + ...
    sum(varprior.e) * sizedata / prod(size(varprior)) + ...
    .5 * sum(sum((misfit.e).^2 + ...
		  misfit.var, dim) ./ effvar);
if nargout > 1,
  c2 = ...
      + .5 * log(2*pi) ...
      + sum(varprior.e) / prod(size(varprior)) + ...
      + .5 * ((misfit.e).^2 + misfit.var) ./ repmat(effvar, 1, ...
						    size(data, 2));
end
