function [c, c2, c3] = kl_param(param, meanprior, varprior, dim)

% Copyright (C) 2002-2005 Harri Valpola, Antti Honkela and Matti Tornio.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if nargin < 4
  dim = 2;
end

effvar = normalvar(varprior);

c = ...
    -.5 * prod(size(param)) - .5 * sum(sum(log(2*pi*param.var))) + ...
    .5 * log(2*pi) * prod(size(param)) + ...
    sum(varprior.e) * prod(size(param)) / prod(size(varprior)) + ...
    .5 * sum(sum((param.e - meanprior.e).^2 + ...
		  param.var + meanprior.var, dim) ./ effvar);

if nargout > 1,
  if prod(size(varprior)) == 1,
    repdim = size(param);
  elseif dim == 1,
    repdim = [size(param, 1) 1];
  else
    repdim = [1 size(param, 1)];
  end
  
  c2 = ...
      -.5 ...
      -.5 * log(2*pi*param.var) ...
      +.5 * log(2*pi) ...
      + repmat(varprior.e, repdim) ...
      +.5 * ((param.e - meanprior.e).^2 + ...
	     param.var + meanprior.var) ./ repmat(effvar, repdim);

  c3{1} = ...
      -5 + .5 * log(2*pi);
  c3{2} = -.5 * log(2*pi*param.var);
  c3{3} = repmat(varprior.e, repdim);
  c3{4} = .5 * ((param.e - meanprior.e).^2 + ...
		param.var + meanprior.var) ./ repmat(effvar, repdim);
  
end
