function [dcp_dwm, dcp_dwv, dcp_dbm, dcp_dbv] = netgrads(x, dx, w, b)
% NETGRADS Calculate partial derivatives of kldiv with respect to
%   network weights
%

% Copyright (C) 2002 Harri Valpola and Antti Honkela.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

% A more efficient way to calculate
%temp = x.multivar;
%for i=1:nsampl
%  bonus = bonus + dx.multi(:,:,i) * temp(:,:,i)';
%end

d0 = size(x.multi, 1);
[d1 d2 d3] = size(dx.multi);
bonus = reshape(dx.multi, [d1 d2*d3]) * reshape(x.multi, [d0 d2*d3])';

dcp_dwm = dx.e * x.e' + ...
	  2 * (dx.extra * x.extra') .* w.e ...
	  + bonus;
dcp_dwv = dx.extra * (x.var + x.e .^ 2)';

dcp_dbm = sum(dx.e, 2);
dcp_dbv = sum(dx.extra, 2);
