function [dcp_dwm, dcp_dwv, dcp_dbm, dcp_dbv] = netgradstop(x, dx, w, b)
% NETGRADSTOP Calculate partial derivatives of kldiv with respect to
%   network weights
%

% Copyright (C) 2002 Harri Valpola and Antti Honkela.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

dcp_dwm = dx.e * x.e' + ...
	  2 * (dx.var * x.var') .* w.e + ...
	  sum(dx.multi, 3);
dcp_dwv = (dx.extra + dx.var) * (x.var + x.e .^ 2)';

dcp_dbm = sum(dx.e, 2);
dcp_dbv = sum(dx.var + dx.extra, 2);
