function [b, aux] = nonlin_adaptive(a, nonlin)
% TANH Hyperbolic tangent of a propability distribution
%
% The result is calculated with a combination of Gauss-Hermite 
% quadrature formula (for high variance inputs) and Taylor 
% approximation (for low variance inputs)
%

% Copyright (C) 1999-2005 Antti Honkela, Harri Valpola,
% Xavier Giannakopoulos and Matti Tornio.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

% The point where use of Gauss-Hermite quadrature begins
epsilon = 1e-3;

highvar = sparse(a.var > epsilon);
lowvar = sparse(~highvar);

b = a;

a1.e = a.e(highvar);
a1.var = a.var(highvar);
a1.multi = a.multi(highvar);
a1.extra = a.extra(highvar);
a2.e = a.e(lowvar);
a2.var = a.var(lowvar);
a2.multi = a.multi(lowvar);
a2.extra = a.extra(lowvar);

[c, aux] = nonlin_hermite(a1, nonlin);
b.e(highvar) = c.e;
b.var(highvar) = c.var;
b.multi(highvar) = c.multi;
b.extra(highvar) = c.extra;

c = nonlin_taylor(a2, nonlin);
b.e(lowvar) = c.e;
b.var(lowvar) = c.var;
b.multi(lowvar) = c.multi;
b.extra(lowvar) = c.extra;

b.highvar = highvar;
b.lowvar = lowvar;
