function b = nonlin_taylor(a, nonlin)
% TANH Hyperbolic tangent of a propability distribution
%
% The result is calculated using second order Taylor approximation
% for expectation and first order for variance:
%
% E[res] = tanh(E[arg]) + 1/2 * tanh''(E[arg]) * Var[arg]
% Var[res] = (tanh'(E[arg]))^2 * Var[arg]
%

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

e = a.e;
var = a.var;

% Calculate first and second derivative of tanh at given point
[val, d, d2] = feval(['d2' nonlin], e);

% Multiply the multivar vectors, i.e. calculate
%  m(:,i,:) = d .* a.multi(:,i,:);
[dim1 dim2 dim3] = size(a.multi);
m = repmat(reshape(d, [dim1 1 dim3]), [1 dim2 1]) .* a.multi;

b.e = val+.5*d2.*var;
b.var = d.^2.*var;
b.multi = m;
b.extra = d.^2 .* a.extra;
