function [data, net, sources, params, clamped, notimedep, missing] = prune(...
    data, net, sources, params, clamped, notimedep, missing, n, t),
% PRUNE  Drops delayed parts of the data and prunes the network accordingly.
%
%  [data, result] = prune(data, result, n, t)
%
%  Embedded data and the ndfa MLPs from a previous run are pruned to contain 
%  only n data channels and t time samples.
%  Partitioning information from the result is automatically used.
%

% Copyright (C) 2002-2005 Harri Valpola, Antti Honkela and Matti Tornio.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

[Nx T] = size(data);

timeindep = notimedep;
if isempty(timeindep),
  parts = 1;
else
  timeindep = [0 find(timeindep(1,:)) T];
  parts = size(timeindep, 2);
end

% Prune networks
net.w2 = net.w2(1:n,:);
net.b2 = net.b2(1:n,:);
params.noise = params.noise(1:n);

% Prune data and sources
if parts == 1,
  sources = sources(:,1:t);
  data = data(1:n,1:t);
  missing = missing(1:n,1:t);
  clamped = clamped(:,1:t);
  if ~isempty(notimedep),
    notimedep = notimedep(1:n,1:t-1);
  end
else
  data_new = [];
  miss_new = [];
  s_new = acprobdist_alpha([]);
  ms = [];
  mt = [];
  for j = 2:parts,
    curpart = [(timeindep(j - 1) + 1):timeindep(j) - t];
    data_new = [data_new data(1:n,curpart)];
    miss_new = [miss_new missing(1:n,curpart)];
    s_new = [s_new sources(:,curpart)];
    ms = [ms clamped(:,curpart)];
    mt = [mt notimedep(1:n,curpart(1:end-1))];
  end
  sources = s_new;
  data = data_new;
  missing = miss_new;
  clamped = ms;
  notimedep = mt;
end
