function s = structop(op, s1, s2)
% STRUCTOP  Apply the operation op to all the fields of two structures
%

% Copyright (C) 2004 Matti Tornio
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

f = fieldnames(s1);
c1 = struct2cell(s1);
c2 = struct2cell(s2);
if size(c1) ~= size(c2)
  error('structop: Structures must be of same type')
end

c = cell(size(c1));

for k=1:length(c1),
  % Char fields are ignored to make this compatible with net-structs
  if ~isa(c1{k}, 'char'),
    c{k} = feval(op, c1{k}, c2{k});
  else
    c{k} = c1{k};
  end
end

s = cell2struct(c, f, 1);
