function [sources, net, tnet, oldgrads, status] = update_new(...
    sources, net, tnet, dcp_dsm, dcp_dsvn, fs, tfs, params, ...
    dcp_dnetm, dcp_dnetv, dcp_dtnetm, dcp_dtnetv, newac, dcp_ac, ...
    data, oldc, status, oldgrads, clamped, missing, notimedep)
% UPDATE_NEW  Perform a line search to find optimal step length
%     and update all parameters based on an approximation of the natural 
%     conjugate gradient
% 2634
% Copyright (C) 1999-2005 Antti Honkela, Harri Valpola,
% Xavier Giannakopoulos and Matti Tornio
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

[newc, datac, restc, dync, netc] = kldiv(...
    [], [], sources, data, net, tnet, params, missing, notimedep, status);

if status.updatesrcs < 0,
  dc_dsm = zeros(size(dcp_dsm));
  dc_dsvn = zeros(size(dcp_dsvn));
  dc_ac = zeros(size(dcp_ac));
else
  dc_dsm = -dcp_dsm;
  dc_dsvn = -dcp_dsvn;
  dc_ac = -dcp_ac;
  % Set gradient for the clamped sources to zeros
  dc_dsm(find(clamped)) = 0;
  dc_dsvn(find(clamped)) = 0;
  dc_ac(find(clamped)) = 0;
end

if status.updatenet < 0,
  dc_dnetm.w1 = zeros(size(dcp_dnetm.w1));
  dc_dnetm.b1 = zeros(size(dcp_dnetm.b1));
  dc_dnetm.w2 = zeros(size(dcp_dnetm.w2));
  dc_dnetm.b2 = zeros(size(dcp_dnetm.b2));
  dc_dnetv.w1 = zeros(size(dcp_dnetv.w1));
  dc_dnetv.b1 = zeros(size(dcp_dnetv.b1));
  dc_dnetv.w2 = zeros(size(dcp_dnetv.w2));
  dc_dnetv.b2 = zeros(size(dcp_dnetv.b2));
else
  dc_dnetm.w1 = -dcp_dnetm.w1;
  dc_dnetm.b1 = -dcp_dnetm.b1;
  dc_dnetm.w2 = -dcp_dnetm.w2;
  dc_dnetm.b2 = -dcp_dnetm.b2;
  dc_dnetv.w1 = -dcp_dnetv.w1;
  dc_dnetv.b1 = -dcp_dnetv.b1;
  dc_dnetv.w2 = -dcp_dnetv.w2;
  dc_dnetv.b2 = -dcp_dnetv.b2;
end

if status.updatetnet < 0,
  dc_dtnetm.w1 = zeros(size(dcp_dtnetm.w1));
  dc_dtnetm.b1 = zeros(size(dcp_dtnetm.b1));
  dc_dtnetm.w2 = zeros(size(dcp_dtnetm.w2));
  dc_dtnetm.b2 = zeros(size(dcp_dtnetm.b2));
  dc_dtnetv.w1 = zeros(size(dcp_dtnetv.w1));
  dc_dtnetv.b1 = zeros(size(dcp_dtnetv.b1));
  dc_dtnetv.w2 = zeros(size(dcp_dtnetv.w2));
  dc_dtnetv.b2 = zeros(size(dcp_dtnetv.b2));
else
  dc_dtnetm.w1 = -dcp_dtnetm.w1;
  dc_dtnetm.b1 = -dcp_dtnetm.b1;
  dc_dtnetm.w2 = -dcp_dtnetm.w2;
  dc_dtnetm.b2 = -dcp_dtnetm.b2;
  dc_dtnetv.w1 = -dcp_dtnetv.w1;
  dc_dtnetv.b1 = -dcp_dtnetv.b1;
  dc_dtnetv.w2 = -dcp_dtnetv.w2;
  dc_dtnetv.b2 = -dcp_dtnetv.b2;
end


% The gradient of both means and variances of sources and weights
grad = [dc_dsm(:); ...
	dc_dnetm.w1(:);  dc_dnetm.w2(:); ...
	dc_dnetm.b1(:);  dc_dnetm.b2(:); ...
	dc_dtnetm.w1(:); dc_dtnetm.w2(:); ...
	dc_dtnetm.b1(:); dc_dtnetm.b2(:); ...
        dc_dsvn(:); ...
        dc_dnetv.w1(:);  dc_dnetv.w2(:); ...
	dc_dnetv.b1(:);  dc_dnetv.b2(:); ...
	dc_dtnetv.w1(:); dc_dtnetv.w2(:); ...
	dc_dtnetv.b1(:); dc_dtnetv.b2(:); ...
        dc_ac(:)];

p0 = [sources.e(:); ...
      net.w1.e(:); net.w2.e(:); ...
      net.b1.e(:); net.b2.e(:); ...
      tnet.w1.e(:); tnet.w2.e(:); ...
      tnet.b1.e(:); tnet.b2.e(:); ...
      sources.var(:); ...
      net.w1.var(:); net.w2.var(:); ...
      net.b1.var(:); net.b2.var(:); ...
      tnet.w1.var(:); tnet.w2.var(:); ...
      tnet.b1.var(:); tnet.b2.var(:); ...
      sources.ac(:)];

% The variances of sources and weights
var = [sources.var(:); ...
       net.w1.var(:);  net.w2.var(:); ...
       net.b1.var(:);  net.b2.var(:); ...
       tnet.w1.var(:); tnet.w2.var(:); ...
       tnet.b1.var(:); tnet.b2.var(:)];

% The diagonal of the Fisher information matrix and its inverse
%invfisher = [var; 2*var.^2; ones(prod(size(dc_ac)),1)];
%invfisher = [var; var.^2; 2*sources.var(:).^2];
invfisher = [var; var.^2; sources.var(:)];
fisher = 1 ./ invfisher;

% Natural gradient and its norm
f = invfisher .* grad;
fn = sum(fisher.*f.^2);

if (oldgrads.norm ~= 0) & isfield(oldgrads, 'f') & ...
   all(size(oldgrads.f) == size(f)),

  % Powell-Beale restarts
  if abs((oldgrads.f'*(fisher.*f))) >= .2*fn && ...
	status.cgreset > 10,
    fprintf('Resetting CG (Powell-Beale restart)\n');
    oldgrads.f = zeros(size(f));
    oldgrads.norm = 0;
    beta = 0;
    status.cgreset = 0;
    oldgrads.cgreset(size(status.kls, 2)) = true;
  else
    % Polak-Ribire formula
    beta = f' * (fisher.*(f-oldgrads.f)) / oldgrads.norm;
    beta = max([0 beta]);

    % Fletcher-Reeves formula (gives inferior results in most cases)
    %beta = fn / oldgrads.norm;
    
    if status.debug,
      fprintf('Beta=%f  ratio=%f\n',beta,abs((oldgrads.f'*(fisher.*f)))/fn);
    end
    status.cgreset = status.cgreset + 1;
  end
  f = f + beta * oldgrads.f;
end

% Store the gradient and state information for the next iteration
oldgrads.norm = fn;
oldgrads.f = f;

vars = (1:size(var,1))+size(var,1);
step = struct('f', f, 'p0', p0, 'vars', vars);

figure(10), clf;
T = prod(size(sources));
nsize = (size(f, 1) - 3 * T)/2;
subplot(3,2,1), plot(step.f(1:T));
subplot(3,2,2), plot(step.f((1:nsize)+T));
subplot(3,2,3), plot(step.f((1:T)+nsize+T));
subplot(3,2,4), plot(step.f((1:nsize)+nsize+2*T));
subplot(3,2,5), plot(step.f((1:T)+2*nsize+2*T));

pause(.1);


x = struct('s', sources, 'net', net, 'tnet', tnet);
fargs = struct('data', data, 'params', params, 'status', status, ...
               'missing', missing, 'notimedep', notimedep);
[x, status.t0] = linesearch(x, step, status.t0, @search_helper, fargs, newc);

sources = x.s;
net = x.net;
tnet = x.tnet;


function [x, c] = search_helper(x, step, lambda, d),
s = x.s;
net = x.net;
tnet = x.tnet;

p = step.p0 + lambda * step.f;
p(step.vars) = max(p(step.vars), .01.*step.p0(step.vars));
%p(step.vars) = step.p0(step.vars);

[p s.e] = pop(p, x.s.e);
[p net.w1.e] = pop(p, net.w1.e);
[p net.w2.e] = pop(p, net.w2.e);
[p net.b1.e] = pop(p, net.b1.e);
[p net.b2.e] = pop(p, net.b2.e);
[p tnet.w1.e] = pop(p, tnet.w1.e);
[p tnet.w2.e] = pop(p, tnet.w2.e);
[p tnet.b1.e] = pop(p, tnet.b1.e);
[p tnet.b2.e] = pop(p, tnet.b2.e);
[p s.var] = pop(p, s.var);
[p net.w1.var] = pop(p, net.w1.var);
[p net.w2.var] = pop(p, net.w2.var);
[p net.b1.var] = pop(p, net.b1.var);
[p net.b2.var] = pop(p, net.b2.var);
[p tnet.w1.var] = pop(p, tnet.w1.var);
[p tnet.w2.var] = pop(p, tnet.w2.var);
[p tnet.b1.var] = pop(p, tnet.b1.var);
[p tnet.b2.var] = pop(p, tnet.b2.var);
[p s.ac]        = pop(p, s.ac);

c = kldiv([], [], s, d.data, net, tnet, d.params, ...
          d.missing, d.notimedep, d.status);

x.s = s;
x.net = net;
x.tnet = tnet;


function [A C] = pop(A, B),
% POP  Implements stack style pop operation with reshaping
%
%  Returns matrix C with shape and size of matrix B from the vector
%  stack A.
%
%  [A, C] = pop(A, B)
%
%  Pop elements from vector A to create a size B matrix C
n = prod(size(B));
C = reshape(A(1:n), size(B));
A = A(n+1:end);
