function [sources, net, tnet] = update_old(...
    sources, net, tnet, dcp_dsm, dcp_dsvn, fs, tfs, params, ...
    dcp_dnetm, dcp_dnetv, dcp_dtnetm, dcp_dtnetv, newac, ...
    data, oldc, status, clamped, missing, notimedep)
% UPDATE_OLD  Update sources and network weights

% Copyright (C) 1999-2007 Antti Honkela, Harri Valpola,
% Xavier Giannakopoulos and Matti Tornio
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

% Get new values for sources and alphas if appropriate
if max([status.updatesrcs, status.updatesrcvars]) >= 0
  newsources = ...
      updatesources(sources, dcp_dsm, dcp_dsvn, fs.multi, tfs, ...
		    params.src, params.noise, newac, clamped);
  if status.updatesrcs < 0
    sources.var = newsources.var;
    sources.nvar = newsources.nvar;
    sources.valpha = newsources.valpha;
    sources.vsign = newsources.vsign;
  else
    sources = newsources;
  end
  sources.ac = newac;
  sources = updatevar(sources);
end

if status.debug >= 2,
  [newc, datac, restc, dync, netc] = kldiv(...
      [], [], sources, data, net, tnet, params, ...
      missing, notimedep, status);
  fprintf('Cost after source update:  c=%.16g\n', newc);
end
    
% Update the network and alphas if appropriate  
if status.updatenet >= 0
  net = updatenetwork(net, dcp_dnetm, dcp_dnetv);
end
if status.updatetnet >= 0
  tnet = updatenetwork(tnet, dcp_dtnetm, dcp_dtnetv);
end
