function [s, net, tnet] = update_s_and_net(s0, net0, tnet0, lambda, step),
% UPDATE_S_AND_NET  Update sources and networks with given step

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% Xavier Giannakopoulos and Matti Tornio.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

net = net0;
tnet = tnet0;
s = s0;

s.e = s.e + lambda * step.s;

net.w1 = probdist(net0.w1.e + lambda * step.net.w1, net0.w1.var);
net.b1 = probdist(net0.b1.e + lambda * step.net.b1, net0.b1.var);
net.w2 = probdist(net0.w2.e + lambda * step.net.w2, net0.w2.var);
net.b2 = probdist(net0.b2.e + lambda * step.net.b2, net0.b2.var);
tnet.w1 = probdist(tnet0.w1.e + lambda * step.tnet.w1, tnet0.w1.var);
tnet.b1 = probdist(tnet0.b1.e + lambda * step.tnet.b1, tnet0.b1.var);
tnet.w2 = probdist(tnet0.w2.e + lambda * step.tnet.w2, tnet0.w2.var);
tnet.b2 = probdist(tnet0.b2.e + lambda * step.tnet.b2, tnet0.b2.var);
