function [s, net, tnet] = update_var(s0, net0, tnet0, alpha, step, status);
% UPDATE_VAR  Update variances with the given step

% Copyright (C) 1999-2005 Antti Honkela, Harri Valpola,
% Xavier Giannakopoulos and Matti Tornio.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

s = s0;
net = net0;
tnet = tnet0;

if status.updatesrcvars >= 0,
  s.nvar = exp(alpha * log(step.s) + (1-alpha) * log(s0.nvar));
  s.ac(:,2:end) = alpha * step.ac(:,2:end) + (1-alpha)*s0.ac(:,2:end);
  s = updatevar(s);
end

if status.updatenet >= 0,
  net.w1.var = exp(alpha * log(step.net.w1) + (1-alpha) * log(net0.w1.var));
  net.w2.var = exp(alpha * log(step.net.w2) + (1-alpha) * log(net0.w2.var));
  net.b1.var = exp(alpha * log(step.net.b1) + (1-alpha) * log(net0.b1.var));
  net.b2.var = exp(alpha * log(step.net.b2) + (1-alpha) * log(net0.b2.var));
end

if status.updatetnet >= 0,
  tnet.w1.var = exp(alpha * log(step.tnet.w1) + (1-alpha) * log(tnet0.w1.var));
  tnet.w2.var = exp(alpha * log(step.tnet.w2) + (1-alpha) * log(tnet0.w2.var));
  tnet.b1.var = exp(alpha * log(step.tnet.b1) + (1-alpha) * log(tnet0.b1.var));
  tnet.b2.var = exp(alpha * log(step.tnet.b2) + (1-alpha) * log(tnet0.b2.var));
end
