function cost = visualize(data, s, net, tnet, params, status, ...
		   missing, clamped, notimedep),
if nargin == 2,
  r = s;
  s = r.sources;
  net = r.net;
  tnet = r.tnet;
  params = r.params;
  status = r.status;
  missing = isnan(data);
  clamped = r.clamped;
  notimedep = r.notimedep;
end


x_tmp = feedfw(s, net, status.approximation);
fs = probdist(x_tmp{4}.e, x_tmp{4}.var);

tx_tmp = acfeedfw(s, tnet, status.approximation);
if (status.freeinitial)
  tfs = probdist([s.e(:,1) tx_tmp{4}.e], ...
		 [zeros(size(s, 1), 1) tx_tmp{4}.var]);
else
  tfs = probdist([zeros(size(s, 1), 1) tx_tmp{4}.e], ...
		 [zeros(size(s, 1), 1) tx_tmp{4}.var]);
end


[temp, obs]     = kl_data(probdist(fs.e - data, fs.var), probdist(0), ...
			  params.noise, 2, missing);
[temp, dyn]     = kl_acparam(s, tfs, params.src, 2, notimedep);
[temp, net_w2]  = kl_param(net.w2, probdist(0), params.net.w2var, 1);
[temp, net_w1]  = kl_param(net.w1, probdist(0), probdist(0));
[temp, tnet_w2] = kl_param(tnet.w2, probdist(0), params.tnet.w2var, 1);
[temp, tnet_w1] = kl_param(tnet.w1, probdist(0), probdist(0));

figure(10), subplot(2,1,1), plot(obs'),     title('Observation mapping');
figure(10), subplot(2,1,2), plot(dyn'),     title('Dynamical mapping');
figure(11), subplot(2,1,1), plot(net_w1'),  title('w1 for obs');
figure(11), subplot(2,1,2), plot(net_w2'),  title('w2 for obs');
figure(12), subplot(2,1,1), plot(tnet_w1'), title('w1 for dyn');
figure(12), subplot(2,1,2), plot(tnet_w2'), title('w2 for dyn');
pause(.05);

cost.obs = obs;
cost.dyn = dyn;
cost.net.w1 = net_w1;
cost.net.w2 = net_w2;
cost.tnet.w1 = tnet_w1;
cost.tnet.w2 = tnet_w2;
