% This script continues a simulation from where run_lorenz.m finished.
% It knows how to continue a simulation if it has been stopped.
% Simply load the last result from file (remember to add NDFA-package
% to path before loading) and start more_lorenz.m.

savepts = [7500 15000 30000 60000 125000 250000 500000 1000000];

while length(res.status.kls) < savepts(end)
  for st = 1:length(savepts)
    if savepts(st) > length(res.status.kls)
      break;
    end
  end
  nfilenam = [filenam '_' int2str(savepts(st))];
  stopiters = savepts(st);

  fprintf('Goal: %d iterations, filename %s\n', stopiters, nfilenam)

  while length(res.status.kls) < stopiters
    res = ndfa(data, res, 'iters', 500);
    save(nfilenam)
    fprintf('File %s saved\n', nfilenam)
  end
end
