function [newsources, newnet, newparams] = ...
    scalesources(sources, net, params)
% SCALESOURCES  Scale the sources so that variance of first layer
%   weights is equal to unity as assumed by their prior

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

scalefactors = sqrt(var(net.w1.e) + mean(net.w1.var));

newsources = sources;
newsources.e = diag(scalefactors) * sources.e;
newsources.var = diag(scalefactors.^2) * sources.var;
newnet = net;
newnet.w1.e = net.w1.e * diag(1 ./ scalefactors);
newnet.w1.var = net.w1.var * diag(1 ./ (scalefactors .^ 2));

newparams = params;
newparams.src.e = params.src.e + log(scalefactors');
[newparams.hyper.src.mean, newparams.hyper.src.var] = ...
    estimatemeanvars(newparams.src, newparams.prior.src.mean, ...
		     newparams.prior.src.var, newparams.hyper.src.var, 1);

newparams.src = estimatevars(sources, newparams.hyper.src, params.src);
%newparams.src = estimatevars(sources, params.hyper.src, params.src);
