function [s, net, params] = try_pruning_source(data, s0, net0, params0, ind, status, diff)
% TRY_PRUNING_SOURCE  Try pruning the given source
%
%     This function is easier to use through PRUNE_EVERYTHING.

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if (nargin == 4) && (isstruct(s0)),
  diff = params0;
  ind = net0;
  status = s0.status;
  params0 = s0.params;
  net0 = s0.net;
  s0 = s0.sources;
end

I = setdiff(1:size(s0, 1), ind);

s = s0(I, :);
net = net0;
net.w1 = net.w1(:, I);

params = params0;
params.src = params.src(I, :);

fs_tmp = feedfw(s, net, status.approximation);
c1 = kl_batch(fs_tmp{4}, s, data, params) + kl_static(net, params);

fs_tmp = feedfw(s0, net0, status.approximation);
c0 = kl_batch(fs_tmp{4}, s0, data, params0) + kl_static(net0, params0);

fprintf('Try pruning source %d: oldc=%f, newc=%f\n', ind, c0, c1);

if (c1 - c0 < diff),
  fprintf('Pruning source %d...\n', ind);
else
  s = s0;
  net = net0;
  params = params0;
end

if nargout == 1,
  val.sources = s;
  val.net = net;
  val.params = params;
  val.status = status;
  s = val;
end
