function summarise_results(res, doplot),
% SUMMARISE_RESULTS  Plot some figures to summarise the result struct

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if nargin < 2,
  doplot = 1;
end

sprior = normalvar(res.params.src);
smvar = std(res.sources.e, 0, 2) .^ 2;
svarm = mean(res.sources.var, 2);

if doplot,
  subplot(2, 2, 1);
  bar([smvar, svarm], 'stacked')
  v = axis; offset = .05*(v(4)-v(3));
  for k=1:length(smvar),
    h = text(k, smvar(k)+svarm(k), ...
	     sprintf('%.2f', smvar(k) / (smvar(k)+svarm(k))));
    set(h, 'HorizontalAlignment', 'center');
    set(h, 'VerticalAlignment', 'bottom');
  end
  title('Distribution of variance of sources')
  legend('var of mean', 'mean of var')
end

w1mvar = var(res.net.w1.e);
w1varm = mean(res.net.w1.var);

if doplot,
  subplot(2, 2, 3);
  bar([w1mvar; w1varm]', 'stacked')
  title('Distribution of variance of w1 per source')
  legend('var of mean', 'mean of var')
end

w1mvarb = std(res.net.w1.e, 0, 2) .^ 2;
w1varmb = mean(res.net.w1.var, 2);

if doplot,
  subplot(2, 2, 2);
  bar([w1mvarb, w1varmb], 'stacked')
  title('Distribution of variance of w1 per hidden neuron')
  legend('var of mean', 'mean of var')
end

w2mvar = var(res.net.w2.e);
w2varm = mean(res.net.w2.var);

if doplot,
  subplot(2, 2, 4);
  bar([w2mvar; w2varm]', 'stacked')
  title('Distribution of variance of w2 per hidden neuron')
  legend('var of mean', 'mean of var')
end
