function v = kl_static(net, params)
% KL_STATIC  calculate batch-independent part of Kullback-Leibler divergence
%
%    Usage:
%      kl = kl_static(net, params)
%      where net (probdist struct) the found values for network,
%      params (probdist struct) estimated values for variances of
%      different values, hypers (probdist struct) estimated values for
%      hyperparameters of the model and priors (probdist struct) user
%      defined prior distributions for the hyperparameters.

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

[v1, v2] = kl_static_split(net, params);
v = v1 + v2;
