function [netv, restv] = kl_static_split(net, params, restv)
% KL_STATIC  calculate batch-independent part of Kullback-Leibler divergence
%
%    Usage:
%      [netv, restv] = kl_static_split(net, params, restv)
%      where net (probdist struct) the found values for network,
%      params (probdist struct) estimated values for variances of
%      different values, hypers (probdist struct) estimated values for
%      hyperparameters of the model and priors (probdist struct) user
%      defined prior distributions for the hyperparameters.
%      The returned value is split to parts dependent on the network
%      weights in netv and independent of network weights restv.
%      If restv is given as argument, it is not re-evaluated.

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

%% NOTE: Assume prior variance of net.w1 to be unity

if nargin < 3,
  restv = ...
      kl_param(params.net.w2var, params.hyper.net.w2var.mean, ...
	       params.hyper.net.w2var.var) + ...
      kl_param(params.noise, params.hyper.noise.mean, ...
	       params.hyper.noise.var) + ...
      kl_param(params.src, params.hyper.src.mean, params.hyper.src.var) + ...
      kl_param(params.hyper.net.w2var.mean, params.prior.net.w2var.mean.mean, ...
	       params.prior.net.w2var.mean.var) + ...
      kl_param(params.hyper.net.w2var.var, params.prior.net.w2var.var.mean, ...
	       params.prior.net.w2var.var.var) + ...
      kl_param(params.hyper.noise.mean, params.prior.noise.mean.mean, ...
	       params.prior.noise.mean.var) + ...
      kl_param(params.hyper.noise.var, params.prior.noise.var.mean, ...
	       params.prior.noise.var.var) + ...
      kl_param(params.hyper.src.mean, params.prior.src.mean.mean, ...
	       params.prior.src.mean.var) + ...
      kl_param(params.hyper.src.var, params.prior.src.var.mean, ...
	       params.prior.src.var.var) + ...
      kl_param(params.hyper.net.b1.mean, params.prior.net.b1.mean.mean, ...
	       params.prior.net.b1.mean.var) + ...
      kl_param(params.hyper.net.b1.var, params.prior.net.b1.var.mean, ...
	       params.prior.net.b1.var.var) + ...
      kl_param(params.hyper.net.b2.mean, params.prior.net.b2.mean.mean, ...
	       params.prior.net.b2.mean.var) + ...
      kl_param(params.hyper.net.b2.var, params.prior.net.b2.var.mean, ...
	       params.prior.net.b2.var.var);
end

netv = kl_param(net.w2, probdist(0, 0), params.net.w2var, 1) + ...
       kl_param(net.b1, params.hyper.net.b1.mean, params.hyper.net.b1.var) + ...
       kl_param(net.b2, params.hyper.net.b2.mean, params.hyper.net.b2.var) + ...
       kl_param(net.w1, probdist(0, 0), probdist(0, 0));
