function res = prune(data, res, sthreshold, wthreshold),
% PRUNE  Try to prune unused sources and hidden neurons
%
%    RES = PRUNE(DATA, RES, STHRESHOLD, WTHRESHOLD)
%    prunues the sources and hidden neurons that only increase the
%    overall cost.  It only tries those parameters, for which the
%    variance of the posterior means is less than ?THRESHOLD times
%    the sum of the same variance and mean of posterior variances.
%    The default value for both thresholds is 0.5.

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if nargin < 4,
  wthreshold = .5;
end
if nargin < 3,
  sthreshold = .5;
end

smvar = var(res.sources.m')';
svarm = mean(res.sources.v, 2);

sstat = smvar ./ (smvar+svarm);
Is = find(sstat < sthreshold);
% Workaround for a Matlab R13 bug
if isempty(Is),
  Is = [];
end
for k=fliplr(Is'),
  [res.sources, res.net, res.params] = ...
      try_pruning_source(data, res.sources, res.net, res.params, ...
			 k, res.status, 0);
end


w1mvar = var(res.net.w1.m')';
w1varm = mean(res.net.w1.v, 2);

w1stat = w1mvar ./ (w1mvar+w1varm);
Iw1 = find(w1stat < wthreshold);
if isempty(Iw1),
  Iw1 = [];
end
for k=fliplr(Iw1'),
  %fprintf('Trying to prune hidden neuron %d...\n', k);
  [res.net, res.params] = ...
      try_pruning_hidden_neuron(data, res.sources, res.net, res.params, ...
				k, res.status, 0);
end

