function C = cost_s( s, ms, vs, diag_qs )

C = 0;
tdim = length(s);
sdim = length( s(1).mean );

if ~diag_qs
    % C_{s,q}
    
    % The covariance matrices q( St ) are all equal
    C = tdim * ( 0.5 * log( abs( det( s.covar ) ) ) ...
                 - 0.5 * sdim * log(2*pi) ...
                 - 0.5 * sdim );
    
    % C_{s,p}
    for t = 1:tdim
        C = C ...
            + 0.5 * sdim * log(2*pi) - 0.5 * sum( vs.mean ) ...
            + 0.5 * sum( ...
                vs.mex .* ...
                ( ( s.mean(:,t) - ms.mean ).^2 + ...
                  ms.var + diag( s(t).covar ) ) );
    end
    
else

    s.var = repmat( diag( s.covar ), 1, tdim );
    C = C + cost_gauss_2( s, ms, vs );

end
