%  COST_SV.M
%
%  ICA with super-Gaussian sources. Calculate the cost corresponding
%  to the sources.
%
function C = cost_sv( s, m, u, diag_qs )

C = 0;
tdim = length(s);
sdim = length( s(1).mean );

if ~diag_qs
    % C_{s,q}
    for t = 1:tdim
        % s(t).mean
        % s(t).covar
        C = C - 0.5 * log( abs( det( s(t).covar ) ) ) ...
            - 0.5 * sdim * log(2*pi) ...
            - 0.5 * sdim;
    end
    
    % C_{s,p}
    % m.mean = 0
    % m.var = 0
    for t = 1:tdim
        C = C ...
            + 0.5 * sdim * log(2*pi) - 0.5 * sum( u(t).mean ) ...
            + 0.5 * sum( ...
                u(t).mex .* ...
                ( ( s(t).mean - m.mean ).^2 + ...
                  m.var + diag( s(t).covar ) ) );
    end
    
else

    for t = 1:tdim
        s(t).var = diag( s(t).covar );
        C = C + cost_gauss_2( s(t), m, u(t) );
    end

end
