%  GENDYN.M
%
%  Generate 10 noisy linear mixtures of 2 Gaussian sources with
%  independent dynamics.
%
function gendyn( a2 )

%close all

a1 = 0.8;
%a2 = 0.6;

% Sources
genAR_1 = gen_ar( [a1; 0], 1, 0 );
[ s1, genAR_1 ] = argen( 1000, genAR_1 );
genAR_1

genAR_2 = gen_ar( [a2; 0], 1, 1 );
[ s2, genAR_2 ] = argen( 1000, genAR_2 );
genAR_2

s = [ s1; s2 ];

% Normalization
ms = mean( s, 2 );
s0 = s - repmat( ms, 1, size(s,2) );

% Linear mixture
A = [ -0.0270    0.2663
      -0.0668    0.6253
      -0.6881   -0.9505
       0.9656    0.9596
      -0.0842   -0.1724
       0.5129    0.3109
       0.0061    0.5632
       0.7107    0.4410
       0.0467    0.6410
       0.9959    0.6504 ];

randn('state',5)
e = randn( size(A,1), size(s,2) );
x = A*s + 0.1*e;

m = mean( x, 2 )
x0 = x - repmat( m, 1, size(s,2) );

[ y, Apca ] = pca_ts(x,2);

Q = orth(A);
prA = Q';
prA*A

% Save the data
x = x';
s = s';
x0 = x0';
datafile = [ 'dyn' int2str(a1*10) '_' int2str(a2*10) '.mat' ]
save( [ package_dir '/DATA/' datafile ], ...
      'a1', 'a2', 'A', 'Apca', 's', 'x', 'x0' )

return


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function generator = gen_ar( A, sigma2, rs )

if length(A) > 2
    error( 'The order should be not greater than 2' )
end

generator.A = A;
generator.sigma2 = sigma2;
sigma = sqrt(sigma2);

if ~( ( A(1) + A(2) < 1 ) & ...
      ( A(2) - A(1) < 1 ) & ...
      ( -1 < A(2) ) & ( A(2) < 1 ) ...
    )
    error( 'The process is not stationary' )
end

generator.B = sigma * sqrt( ( 1 + A(2) )*...
                            ( ( 1 - A(2) )^2 - A(1)^2 )/...
                            ( 1 - A(2) ) );

if nargin >= 3 & ~isempty(rs)
    generator.state.rs = rs;
    generator.state.xd = zeros(1,length(A));
else
    generator.state = [];
end

return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ x, generator ] = argen( t, parm1, sigma2 )

if isstruct(parm1)
    generator = parm1;
else
    generator = gen_ar( parm1, sigma2 );
end

d = length(generator.A); % The order of the AR-model

if isfield( generator, 'state' ) & ~isempty(generator.state)
    randn( 'state', generator.state.rs );
    xd = generator.state.xd;
else
    xd = zeros(1,d);
end

for ix = 1:t
    x(:,ix) = xd*generator.A + generator.B * randn;
    xd = [ x(:,ix) xd(:,1:end-1) ];
end

if nargout == 2
    generator.state.rs = randn('state');
    generator.state.xd = xd;
end

return