%  MOGICA2NET.M
%
%  Save variables of the ICA model with the mixture-of-Gaussians model
%  for the sources as one structure.
%
function net = mogica2net( A, s, vx, Vvx, Mvx,...
                           Mmms, Vmms, Mvms, Vvms,...
                           Mmvs, Vmvs, Mvvs, Vvvs,...
                           Mms, Vms, Mvs, Vvs,...
                           ms, vs, mog_pi, lambda )


net.Mmms = Mmms;
net.Vmms = Vmms;
net.Mvms = Mvms;
net.Vvms = Vvms;

net.Mmvs = Mmvs;
net.Vmvs = Vmvs;
net.Mvvs = Mvvs;
net.Vvvs = Vvvs;

net.Mms = Mms;
net.Vms = Vms;
net.Mvs = Mvs;
net.Vvs = Vvs;
net.ms = ms;
net.vs = vs;
net.mog_pi = mog_pi;
net.lambda = lambda;

net.s_all = s;
net.A = A;

net.Mvx = Mvx;
net.Vvx = Vvx;
net.vx = vx;


for t = 1:length(s)
    s_m(:,t) = s(t).mean;
end

net.s = s_m;
net.a = A.mean;

return