%  COST_GAUSS_2.M
%
%  The cost corresponding to Gaussian variables s (vector or matrix)
%  with the same prior mean m and variance v for every row of s.
%
function C = cost_gauss_2( s, m, v )

N = size(s.mean);
% prod(N) - The number of Gaussian variables

% C_{s,q}:
C = -0.5 * prod(N) - 0.5 * sum( sum( log( 2*pi*s.var ) ) );

% C_{s,p}
C = C ...
    + 0.5 * prod(N) * log(2*pi) - 0.5 * N(2) * sum(v.mean) ...
    + 0.5 * sum( sum( ...
        repmat(v.mex,1,N(2)) .* ...
        ( ( s.mean - repmat(m.mean,1,N(2)) ).^2 + ...
          repmat(m.var,1,N(2)) + s.var ) ) );

return

