%  GENSG.M
%
%  Generate 10 noisy linear mixtures of 2 Gaussian sources with
%  super-Gaussian model.
%
%
function [ data, gnr ] = gensg(nu)

if nargin == 0
    nu = 1;
end

nsampl = 1000;
nsrc = 2;

rand('state',7)
randn('state',1)

u = exp( nu * randn(nsrc,nsampl) );
s = randn(nsrc,nsampl).*u;

A = [ -0.0270    0.2663
      -0.0668    0.6253
      -0.6881   -0.9505
       0.9656    0.9596
      -0.0842   -0.1724
       0.5129    0.3109
       0.0061    0.5632
       0.7107    0.4410
       0.0467    0.6410
       0.9959    0.6504 ];

randn('state',5)
e = randn( size(A,1), size(s,2) );
std( A*s, 1, 2 ).^2
data = A*s + 0.1*e;

mean( data, 2 )

gnr.A = A;
gnr.s = s;

[ y, Apca ] = pca_ts(data,2);

gnr.prA = orth(A)';

hold off
x_2 = gnr.prA*data;
plot( x_2(1,:), x_2(2,:), '.', 'MarkerSize', 4 )
axis equal
h_true = plot_dir( gnr.prA*A, 'LineStyle', ':', 'Color', [ 1 0 0 ] );
[s_ica, A_ica, W] = fastica( data,...
                             'g', 'tanh', ...
                             'numOfIC', 2,...
                             'displayMode', 'off' );

h_ica = plot_dir( gnr.prA*A_ica, 'LineStyle', '--', 'Color', [ 0 0 1 ] );

legend( [ h_true(1) h_ica(1) ], 'True A', 'FastICA' )

% Save the data
x = data';
s = s';

str_nu = sprintf( '%.1f', nu );
str_nu( find(str_nu == '.') ) = '_';
datafile = [ 'sg_' str_nu '.mat' ]

save( [ package_dir '/DATA/' datafile ], ...
      'nu', 'A', 'Apca', 'A_ica', 's', 'x' )

if nargout == 0
    clear data
end

return