%  UPDATE_LAMBDA.M
%
%  ICA with the mixture-of-Gaussians model for the sources. Update the
%  posterior approximation for the approximating coefficents lambda.
%
function lambda = update_lambda( lambda, mog_pi, s, ms, vs )

sdim = length(lambda);
tdim = size(lambda{1},2);

for j = 1:sdim
    for t = 1:tdim
        %mog_pi{j}.counts
        log_lambda = mog_pi{j}.explog - 0.5 * (...
            log(2*pi) - vs{j}.mean +...
            vs{j}.mex .* ( ( s(t).mean(j) - ms{j}.mean ).^2 + ...
                          ms{j}.var + s(t).covar(j,j) ) );
        
        lmbd = exp( log_lambda ); % Unnormalized
        
        lambda{j}(:,t) = lmbd / sum(lmbd);
        %lambda{j}(:,t)
    end
end

