%  UPDATE_MOGC.M
%
%  ICA with the mixture-of-Gaussians model for the sources. Update the
%  posterior approximation for the MoG coefficents.
%
function mog_pi = update_mogc( mog_pi, lambda )

sdim = length(mog_pi);

for j = 1:sdim
    % Prior counts for pi: the first term
    mog_pi{j}.counts = 1 + sum( lambda{j}, 2 );
    mog_pi{j}.mean = mog_pi{j}.counts / sum( mog_pi{j}.counts );
    mog_pi{j}.explog = explog_pi( mog_pi{j} );
end