%  COST_GAUSS.M
%
%  The cost corresponding to Gaussian variables s (vector or matrix)
%  with the same prior mean m and variance v.
%
function C = cost_gauss( s, m, v )

N = prod( size(s.mean) );          % The number of Gaussian variables

% C_{s,q}:
C = -0.5 * N - 0.5 * sum( sum( log( 2*pi*s.var ) ) );

% C_{s,p}
C = C ...
    + 0.5 * N * ( log(2*pi) - v.mean ) ...
    + 0.5 * sum( sum( ...
        v.mex * ( ( s.mean - m.mean ).^2 + m.var + s.var ) ) );

return


