%  COST_SD.M
%
%  ICA with temporally correlated sources. Calculate the cost
%  corresponding to the sources.
%
function C = cost_sd( s, B, vs, diag_qs )

C = 0;
tdim = length(s);
sdim = length( s(1).mean );

if ~diag_qs
    % C_{s,q}
    for t = 1:tdim
        % s(t).mean
        % s(t).covar
        C = C - 0.5 * log( abs( det( s(t).covar ) ) ) ...
            - 0.5 * sdim * log(2*pi) ...
            - 0.5 * sdim;
    end
    
    % C_{s,p}
    C = C + 0.5 * sdim * log(2*pi) ...
        + 0.5 * sum( s(1).mean.^2 + diag( s(1).covar ) );
    for t = 2:tdim
        C = C ...
            + 0.5 * sdim * log(2*pi) - 0.5 * sum( vs.mean ) ...
            + 0.5 * sum( ...
                vs.mex .* ...
                ( ( s(t).mean - B.mean .* s(t-1).mean ).^2 + ...
                  diag( s(t).covar ) + ...
                  B.mean.^2 .* diag( s(t-1).covar ) + ...
                  B.var .* ( s(t-1).mean.^2 + diag( s(t-1).covar ) ) ) );
    end
    
else

    const0.mean = 0;
    const0.var = 0;
    const0.mex = meanexp( const0 );
    
    C = cost_gauss( s(1), const0, const0 );
    for t = 2:tdim
        s(t).var = diag( s(t).covar );
        m.mean = B.mean .* s(t-1).mean;
        m.var = B.mean.^2 .* diag( s(t-1).covar ) + ...
                B.var .* ( s(t-1).mean.^2 + diag( s(t-1).covar ) );
        C = C + cost_gauss_2( s(t), m, v );
    end

end
