%  COST_SGICA.M
%
%  Calculate the cost function for the ICA model with super-Gaussian
%  sources.
%
function C = cost_sgica( x, A, s, vx, Vvx, Mvx, u,...
                         Mmu, Vmu, Mvu, Vvu, mu, vu, diag_qs )

if nargin < 14 | isempty(diag_qs)
    diag_qs = 0;
end

const0.mean = 0;
const0.var = 0;
const0.mex = meanexp( const0 );

C = cost_gauss( Mmu, const0, const0 ) +...
    cost_gauss( Vmu, const0, const0 ) +...
    cost_gauss( mu, Mmu, Vmu ) +...
    cost_gauss( Mvu, const0, const0 ) +...
    cost_gauss( Vvu, const0, const0 ) +...
    cost_gauss( vu, Mvu, Vvu ) +...
    cost_gauss( Mvx, const0, const0 ) +...
    cost_gauss( Vvx, const0, const0 ) +...
    cost_gauss( vx, Mvx, Vvx ) +...
    cost_gauss( A, const0, const0 ) +...
    cost_sv( s, const0, u, diag_qs ) +...
    cost_u( u, mu, vu ) +...
    cost_x( x, A, s, vx, diag_qs );

return

