%  DYNICA2NET.M
%
%  Save variables of the ICA model with temporally correlated sources
%  as one structure.
%
function net = dynica2net( A, s, B, vs, Vvs, Mvs, vx, Vvx, Mvx )

tdim = length(s);

for t = 1:tdim
    s_m(:,t) = s(t).mean;
    s_v(:,:,t) = s(t).covar;
end

net.a = A.mean;
net.a_var = A.var;

net.s = s_m;
net.s_covar = s_v;

net.bs = B.mean;
net.bs_var = B.var;

net.vs = vs.mean;
net.vs_var = vs.var;

net.mvs = Mvs.mean;
net.mvs_var = Mvs.var;

net.vvs = Vvs.mean;
net.vvs_var = Vvs.var;

net.vx = vx.mean;
net.vx_var = vx.var;

net.mvx = Mvx.mean;
net.mvx_var = Mvx.var;

net.vvx = Vvx.mean;
net.vvx_var = Vvx.var;

return
