%  SGICA2NET.M
%
%  Save variables of the ICA model with super-Gaussian sources as one
%  structure.
%
function net = sgica2net( A, s, vx, Vvx, Mvx,...
                          u, Mmu, Vmu, Mvu, Vvu, mu, vu )

tdim = length(s);

for t = 1:tdim
    s_m(:,t) = s(t).mean;
    s_v(:,:,t) = s(t).covar;
end

net.s = s_m;
net.s_covar = s_v;

for t = 1:tdim
    u_m(:,t) = u(t).mean;
    u_v(:,t) = u(t).var;
end

net.a = A.mean;
net.a_var = A.var;

net.vx = vx.mean;
net.vx_var = vx.var;

net.mvx = Mvx.mean;
net.mvx_var = Mvx.var;

net.vvx = Vvx.mean;
net.vvx_var = Vvx.var;


net.Mmu = Mmu.mean;
net.Mmu_var = Mmu.var;

net.Vmu = Vmu.mean;
net.Vmu_var = Vmu.var;

net.Mvu = Mvu.mean;
net.Mvu_var = Mvu.var;

net.Vvu = Vvu.mean;
net.Vvu_var = Vvu.var;

net.mu = mu.mean;
net.mu_var = mu.var;

net.vu = vu.mean;
net.vu_var = vu.var;

net.u = u_m;
net.u_var = u_v;

return