%  UPDATE_B.M
%
%  ICA with temporally correlated sources. Update the posterior
%  approximation for the diagonal matrix B of the source dynamics.
%
function B = update_B( B, s, vs )

sdim = length(B.mean);
tdim = length(s);

for j = sdim:-1:1
    
    %                                   N
    % L = <\beta_j> + < exp{v_{s,j}} > sum < S_{t-1,j}^2 >
    %                                  t=2
    L = 0;
    for t = 2:tdim
        L = L + s(t-1).mean(j)^2 + s(t-1).covar(j,j);
    end
    L = 1 + vs.mex(j) * L;
        
    % ~b_{jj}~ = L^{-1}
    B.var(j) = inv(L);
        
    % ~b_{jj}~ <b_{jj}> = < exp{v_{s,j}} > *
    %      N
    %     sum <S_{t,j} S_{t-1,j} >
    %     t=2
    %
    M = 0;
    for t = 2:tdim
        M = M + s(t).mean(j) * s(t-1).mean(j);
    end
    B.mean(j) = B.var(j) * vs.mex(j) * M;
    
end