%  UPDATE_VU.M
%
%  ICA with super-Gaussian sources. Update the posterior approximation for
%  the variance hyperparameter of the variance nodes.
%
function vu = update_vu( vu, Mvu, Vvu, u, mu )

tdim = length(u);
sdim = length(vu.mean);

for j = 1:sdim
    
    % From itself:
    %   gme = < exp Vvu > ( <vu_j> - <Mvu> )
    %   gva = 0.5 <exp Vvu>
    %   gex = 0
    gme = Vvu.mex * ( vu.mean(j) - Mvu.mean );
    gva = 0.5 * Vvu.mex;
    gex = 0;
    
    % From children u:
    %          N
    %   gme = sum -0.5
    %         t=1
    %
    %   gva = 0
    %
    %          N
    %   gex = sum 0.5 [ ( <u_{t,j}> - <mu_j> )^2 + ~u_{t,j}~ + ~mu_j~ ]
    %         t=1
    %
    gme = gme - tdim/2;
    
    for t = 1:tdim
        gex = gex + ...
              0.5 * ( ( u(t).mean(j) - mu.mean(j) )^2 +...
                      u(t).var(j) + mu.var(j) );
    end
    
    [vu.mean(j), vu.var(j)] = var_newton( vu.mean(j), vu.var(j),...
                                          gme, gva, gex );
    
end

vu.mex  = meanexp( vu );
