\name{ICMg-package}
\alias{ICMg-package}
\alias{ICMg}
\docType{package}
\title{
ICMg - Interaction component models for gene modules
}
\description{
Probabilistic analysis of protein-protein interaction measurements and gene expression data. Provides functions for computing component membership distributions for genes, also interpretable as functional gene modules or clusters.
}
\details{
\tabular{ll}{
Package: \tab ICMg\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2009-03-09\cr
License: \tab GNU GPL 3 or any later version (at your option)\cr
}
Function ICMg.combined.sampler can be used to sample components for combined interaction and functional data. ICMg.links.sampler does the same for interaction data only. There are two versions of the iteration functions available (R and C) and it is highly recommended to use the faster C versions.
}
\author{
Juuso Parkkinen <juuso.parkkinen@tkk.fi>
Maintainer: Juuso Parkkinen <juuso.parkkinen@tkk.fi>
}
\references{TBA}
\examples{
	## Load data and set parameters
	data(osmo)
	C.boost = 1 ## Use faster C funtions
	alpha = 10
	beta = 0.01
	B.num = 2
	B.size = 5
	S.num = 2  
	S.size = 5
 	C = 10
	pm0 = 0
	V0 = 1               
	V = 0.1

	## Run sampling
	res = ICMg.combined.sampler(osmo$ppi, osmo$exp, C, alpha, beta, pm0, V0, V, B.num, B.size, S.num, S.size, C.boost) 
	## Compute component membership probabilities for nodes
  	res$comp.memb <- ICMg.get.comp.memberships(osmo$ppi, res)
  	## Compute (hard) clustering for nodes
  	res$clustering <- apply(res$comp.memb, 2, which.max)
}
\keyword{ package }
