function constant = get_constant_term(P,weights,Pnz,I,J,method)
% Calculate the constant term of the specific visualizaiton method
% 
% Copyright (c) 2014, Zhirong Yang (Aalto University)
% All rights reserved.

switch method
    case 'sne'
        constant = sum(Pnz.*log(Pnz+eps));
    case 'ssne'
        constant = sum(Pnz.*log(Pnz+eps));
    case 'tsne'
        constant = sum(Pnz.*log(Pnz+eps));
    case 'wtsne'
        constant = sum(Pnz.*log(Pnz+eps))-2*sum(P*log(weights));
    case {'nerv', 'ee', 'linlog'}
        constant = 0;
    case 'mdsks'
        constant = 0.5 * log(Pnz'*Pnz);
    otherwise
        error('unknown method');
end