function Y = sne_p(P)
% compute Stochastic Neighbor Embedding (SNE) layout
% 
% Copyright (c) 2014, Zhirong Yang (Aalto University)
% All rights reserved.


method = 'sne';
P = preprocess_input_similarities(P, method);

theta = 2;
rng('default');
Y0 = randn(size(P,1),2)*1e-4;
check_step = 1;
tol = 1e-4;
max_time = inf;
verbose = true;
optimizer = 'mm';
recordYs = false;

fprintf('===============================================\n');
fprintf('Initialization stage\n');
fprintf('===============================================\n');
attr = 4;
max_iter = 30;
Y1 = ne_wrapper(P, method, Y0, attr, theta, max_iter, check_step, tol, max_time, verbose, optimizer, recordYs);

fprintf('===============================================\n');
fprintf('Long-run stage\n');
fprintf('===============================================\n');
attr = 1;
max_iter = 100;
Y = ne_wrapper(P, method, Y1, attr, theta, max_iter, check_step, tol, max_time, verbose, optimizer, recordYs);

