methods = {...
    'tsne', ...
    'ssne', ...
    'sne', ...
    'nerv', ...
    'linlog', ...
    'ee', ...
    'mdsks' ...
    'wtsne'
    };

optimizers = {...
    'sd', ...
    'momentum', ...
    'gd', ...
    'mm', ...
    'fminunc', ...
    'lbfgs', ...
    'vdm', ...
    'fphssne' ...
    };

nm = length(methods);
no = length(optimizers);

load dolphins.mat;
P = sparse(double(A+A'>0));

attr = 1;
theta = 2;
max_iter = 400;
check_step = max(1,round(max_iter/10));
tol = 1e-20;
max_time = inf;
verbose = true;

rng('default');
Y0 = randn(size(P,1),2)*1e-4;

Y = cell(nm,no);

for mi=1:nm
% for mi=4
    method = methods{mi};
    
    switch method
        case 'nerv'
            param1 = 0.9; % lambda
            param2 = 1e-10; % epsilon
        case 'linlog'
            param1 = 1; % lambda
            param2 = 0;
        case 'ee'
            param1 = 1; % lambda
            param2 = 0;
        otherwise
            param1 = 0;
            param2 = 0;
    end
    
    for oi=1:no
%     for oi=5
        optimizer = optimizers{oi};
        
        fprintf('mi=%d/%d, %s, oi=%d/%d, %s\n', mi, nm, method, oi, no, optimizer);
        
        [Y{mi,oi}, Cs, ts, Ys, extra] = ne_wrapper(P, method, Y0, attr, theta, max_iter, check_step, tol, max_time, verbose, optimizer, param1, param2);
        
    end
end
        