function Y = wtsne_p(P, do_init)
% compute 2-D coordinates by weighted t-SNE
%  
%   Y = wtsne_p(P, do_init)
% 
% Input: 
%   P: N x N, pairwise similarities or network (weighted) adjacency matrix
%   do_init: boolean, do over-attraction initialization or not, default=false
% 
% Output:
%   Y: N x 2, 2-D coordinates
%
% Copyright (c) 2014, Zhirong Yang (Aalto University)
% All rights reserved.

if ~exist('do_init', 'var') || isempty(do_init)
    do_init = false;
end
method = 'wtsne';
P = preprocess_input_similarities((P+P')/2, method);

theta = 2;
rng('default');
Y0 = randn(size(P,1),2)*1e-4;
check_step = 1;
tol = 1e-4;
max_time = inf;
verbose = true;
optimizer = 'mm';
recordYs = false;

if do_init
    fprintf('===============================================\n');
    fprintf('Initialization stage\n');
    fprintf('===============================================\n');
    attr = 4;
    max_iter = 30;
    Y1 = ne_wrapper(P, method, Y0, attr, theta, max_iter, check_step, tol, max_time, verbose, optimizer, recordYs);
else
    Y1 = Y0;
end

fprintf('===============================================\n');
fprintf('Long-run stage\n');
fprintf('===============================================\n');
attr = 1;
max_iter = 300;
Y = ne_wrapper(P, method, Y1, attr, theta, max_iter, check_step, tol, max_time, verbose, optimizer, recordYs);
